Scriptname lbQuestMainScript Extends Quest

lbQuestMCMScript Property aaaQuestMCM Auto
lbQuestMeterScript Property aaaQuestMeter1 Auto
lbQuestMeterScript Property aaaQuestMeter2 Auto
lbQuestMeterScript Property aaaQuestMeter3 Auto
Spell Property aaaSpellTankLB1 Auto
Spell Property aaaSpellTankLB2 Auto
Spell Property aaaSpellTankLB3 Auto
Spell Property aaaSpellHealerLB1 Auto
Spell Property aaaSpellHealerLB2 Auto
Spell Property aaaSpellHealerLB3 Auto
Spell Property aaaSpellMeleeLB1 Auto
Spell Property aaaSpellMeleeLB2 Auto
Spell Property aaaSpellMeleeLB3 Auto
Spell Property aaaSpellCasterLB1 Auto
Spell Property aaaSpellCasterLB2 Auto
Spell Property aaaSpellCasterLB3 Auto
Perk Property aaaPerkLB Auto
Sound Property aaaSoundActivated Auto
Sound Property aaaSoundCharged Auto
Sound Property MAGFail Auto
Message Property aaaMessageSelectLB Auto
Actor Property PlayerRef Auto

Int _KeyToTankLB = -1
Int Property KeyToTankLB
	Int Function Get()
		return _KeyToTankLB
	EndFunction

	Function Set(Int value)
		_KeyToTankLB = value
	EndFunction
EndProperty

Int _KeyToHealerLB = -1
Int Property KeyToHealerLB
	Int Function Get()
		return _KeyToHealerLB
	EndFunction

	Function Set(Int value)
		_KeyToHealerLB = value
	EndFunction
EndProperty

Int _KeyToMeleeLB = -1
Int Property KeyToMeleeLB
	Int Function Get()
		return _KeyToMeleeLB
	EndFunction

	Function Set(Int value)
		_KeyToMeleeLB = value
	EndFunction
EndProperty

Int _KeyToCasterLB = -1
Int Property KeyToCasterLB
	Int Function Get()
		return _KeyToCasterLB
	EndFunction

	Function Set(Int value)
		_KeyToCasterLB = value
	EndFunction
EndProperty

Int _KeyToOpenMenu = -1
Int Property KeyToOpenMenu
	Int Function Get()
		return _KeyToOpenMenu
	EndFunction

	Function Set(Int value)
		_KeyToOpenMenu = value
	EndFunction
EndProperty

Bool _MultiMeter = true
Bool Property MultiMeter
	Bool Function Get()
		return _MultiMeter
	EndFunction

	Function Set(Bool value)
		_MultiMeter = value
	EndFunction
EndProperty

Int _MeterColor0 = 0xFFFF00
Int Property MeterColor0
	Int Function Get()
		return _MeterColor0
	EndFunction

	Function Set(Int value)
		_MeterColor0 = value
	EndFunction
EndProperty

Int _MeterColor1 = 0xFFFF00
Int Property MeterColor1
	Int Function Get()
		return _MeterColor1
	EndFunction

	Function Set(Int value)
		_MeterColor1 = value
	EndFunction
EndProperty

Int _MeterColor2 = 0xFFFF00
Int Property MeterColor2
	Int Function Get()
		return _MeterColor2
	EndFunction

	Function Set(Int value)
		_MeterColor2 = value
	EndFunction
EndProperty

Int _MeterColor3 = 0xFFFF00
Int Property MeterColor3
	Int Function Get()
		return _MeterColor3
	EndFunction

	Function Set(Int value)
		_MeterColor3 = value
	EndFunction
EndProperty

Int LimitBreakLevel
Int ActivatedLevel


Function AddLimitBreakLevel(Int aiLevel)
	if LimitBreakLevel >= 300
		return
	endif

	Int LastLevel = LimitBreakLevel

	LimitBreakLevel += aiLevel

	if LimitBreakLevel > 300
		LimitBreakLevel = 300
	endif

	if ActivatedLevel
		return
	endif

	if _MultiMeter
		Bool bCharged = false

		if LastLevel < 100
			if LimitBreakLevel >= 100
				aaaQuestMeter1.SetPercent(1.0, a_force = false)
				bCharged = true
			else
				aaaQuestMeter1.SetPercent( (LimitBreakLevel % 100) as Float * 0.01, a_force = false )
			endif
		endif

		if LastLevel < 200
			if LimitBreakLevel >= 200
				aaaQuestMeter2.SetPercent(1.0, a_force = false)
				bCharged = true
			elseif LimitBreakLevel > 100
				aaaQuestMeter2.SetPercent( (LimitBreakLevel % 100) as Float * 0.01, a_force = false )
			endif
		endif

		if LastLevel < 300
			if LimitBreakLevel >= 300
				aaaQuestMeter3.SetPercent(1.0, a_force = false)
				bCharged = true
			elseif LimitBreakLevel > 200
				aaaQuestMeter3.SetPercent( (LimitBreakLevel % 100) as Float * 0.01, a_force = false )
			endif
		endif

		if bCharged
			Utility.Wait(0.2)
			aaaSoundCharged.Play(PlayerRef)

			if LimitBreakLevel >= 300
				aaaQuestMeter1.PrimaryColor = _MeterColor3
				aaaQuestMeter2.PrimaryColor = _MeterColor3
				aaaQuestMeter3.PrimaryColor = _MeterColor3
			endif
		endif
	else
		Int iLevel = LimitBreakLevel / 100
		Float fPercent = (LimitBreakLevel % 100) as Float * 0.01
		Bool bCharged = iLevel != LastLevel / 100

		if bCharged
			aaaQuestMeter2.SetPercent(1.0, a_force = false)
			Utility.Wait(0.2)
			aaaSoundCharged.Play(PlayerRef)

			if iLevel < 3
				aaaQuestMeter2.SetPercent(0.0, a_force = true)
			endif

			if iLevel == 1
				aaaQuestMeter2.PrimaryColor = _MeterColor1
			elseif iLevel == 2
				aaaQuestMeter2.PrimaryColor = _MeterColor2
			elseif iLevel == 3
				aaaQuestMeter2.PrimaryColor = _MeterColor3
			endif

			if iLevel < 3
				aaaQuestMeter2.SetPercent(fPercent, a_force = false)
			endif
		else
			aaaQuestMeter2.SetPercent(fPercent, a_force = false)
		endif
	endif

	;Debug.Trace("LimitBreakLevel = " + LimitBreakLevel)
EndFunction


Function ResetLimitBreakLevel()
	ActivatedLevel = 0

	aaaQuestMeter1.SetPercent(0.0, a_force = true)
	aaaQuestMeter2.SetPercent(0.0, a_force = true)
	aaaQuestMeter3.SetPercent(0.0, a_force = true)

	;Debug.Trace("ResetLimitBreakLevel")
EndFunction


Function RefreshMeter()
	if _MultiMeter
		if LimitBreakLevel >= 300
			aaaQuestMeter1.PrimaryColor = _MeterColor3
			aaaQuestMeter2.PrimaryColor = _MeterColor3
			aaaQuestMeter3.PrimaryColor = _MeterColor3
		elseif LimitBreakLevel >= 200
			aaaQuestMeter1.PrimaryColor = _MeterColor2
			aaaQuestMeter2.PrimaryColor = _MeterColor2
			aaaQuestMeter3.PrimaryColor = _MeterColor2
		elseif LimitBreakLevel >= 100
			aaaQuestMeter1.PrimaryColor = _MeterColor1
			aaaQuestMeter2.PrimaryColor = _MeterColor1
			aaaQuestMeter3.PrimaryColor = _MeterColor1
		else
			aaaQuestMeter1.PrimaryColor = _MeterColor0
			aaaQuestMeter2.PrimaryColor = _MeterColor0
			aaaQuestMeter3.PrimaryColor = _MeterColor0
		endif

		if LimitBreakLevel >= 100
			aaaQuestMeter1.SetPercent(1.0, a_force = true)
		else
			aaaQuestMeter1.SetPercent( (LimitBreakLevel % 100) as Float * 0.01, a_force = true )
		endif

		if LimitBreakLevel >= 200
			aaaQuestMeter2.SetPercent(1.0, a_force = true)
		elseif LimitBreakLevel > 100
			aaaQuestMeter2.SetPercent( (LimitBreakLevel % 100) as Float * 0.01, a_force = true )
		else
			aaaQuestMeter2.SetPercent(0.0, a_force = true)
		endif

		if LimitBreakLevel >= 300
			aaaQuestMeter3.SetPercent(1.0, a_force = true)
		elseif LimitBreakLevel > 200
			aaaQuestMeter3.SetPercent( (LimitBreakLevel % 100) as Float * 0.01, a_force = true )
		else
			aaaQuestMeter3.SetPercent(0.0, a_force = true)
		endif
	else
		if LimitBreakLevel >= 300
			aaaQuestMeter2.PrimaryColor = _MeterColor3
			aaaQuestMeter2.SetPercent(1.0, a_force = true)
		else
			if LimitBreakLevel >= 200
				aaaQuestMeter2.PrimaryColor = _MeterColor2
			elseif LimitBreakLevel >= 100
				aaaQuestMeter2.PrimaryColor = _MeterColor1
			else
				aaaQuestMeter2.PrimaryColor = _MeterColor0
			endif

			aaaQuestMeter2.SetPercent( (LimitBreakLevel % 100) as Float * 0.01, a_force = true )
		endif
	endif

	;Debug.Trace("RefreshMeter")
EndFunction


; LBが使えるか判定する
Bool Function CanUseLB(Bool abHealerLB = false, Bool abAutoActivate = true)
	;Debug.Trace("CanUseLB")

	if LimitBreakLevel < 100
		; LBゲージが足りないときは使えない
	elseif PlayerRef.GetActorValue("Paralysis")
		; 麻痺している時は使えない
	elseif !abHealerLB && PlayerRef.GetActorValue("Health") <= 0.0
		; ヘルスがないときは使えない、ただしヒーラーLBだけは使える
	else
		; 使える
		if abAutoActivate
			;Debug.Trace("CanUseLB: Activate")
			ActivatedLevel = LimitBreakLevel
			LimitBreakLevel = 0
			aaaSoundActivated.Play(PlayerRef)
		endif

		return true
	endif

	MAGFail.Play(PlayerRef)
	aaaQuestMeter1.StartFlash(a_force = true)
	aaaQuestMeter2.StartFlash(a_force = true)
	aaaQuestMeter3.StartFlash(a_force = true)

	return false
EndFunction


Function DoTankLB()
	if ActivatedLevel >= 300
		aaaSpellTankLB3.Cast(PlayerRef)
	elseif ActivatedLevel >= 200
		aaaSpellTankLB2.Cast(PlayerRef)
	else
		aaaSpellTankLB1.Cast(PlayerRef)
	endif

	RegisterForSingleUpdate(2.0)
EndFunction


Function DoHealerLB()
	Float fHealth = PlayerRef.GetActorValue("Health")
	Float fRestore

	if fHealth < 0.0
		Float fMagnitude = 0.25

		if ActivatedLevel >= 300
			fMagnitude = 1.0
		elseif ActivatedLevel >= 200
			fMagnitude = 0.5
		endif

		fRestore = 0.0 - fHealth + PlayerRef.GetBaseActorValue("Health") * fMagnitude
	else
		fRestore = PlayerRef.GetBaseActorValue("Health")
	endif

	;Debug.Trace("DoHealerLB: Restore=" + fRestore)
	PlayerRef.RestoreActorValue("Health", fRestore)

	if ActivatedLevel >= 300
		aaaSpellHealerLB3.Cast(PlayerRef)
	elseif ActivatedLevel >= 200
		aaaSpellHealerLB2.Cast(PlayerRef)
	else
		aaaSpellHealerLB1.Cast(PlayerRef)
	endif

	RegisterForSingleUpdate(2.0)
EndFunction


Function DoMeleeLB()
	if ActivatedLevel >= 300
		aaaSpellMeleeLB3.Cast(PlayerRef)
	elseif ActivatedLevel >= 200
		aaaSpellMeleeLB2.Cast(PlayerRef)
	else
		aaaSpellMeleeLB1.Cast(PlayerRef)
	endif

	RegisterForSingleUpdate(2.0)
EndFunction


Function DoCasterLB()
	if ActivatedLevel >= 300
		aaaSpellCasterLB3.Cast(PlayerRef)
	elseif ActivatedLevel >= 200
		aaaSpellCasterLB2.Cast(PlayerRef)
	else
		aaaSpellCasterLB1.Cast(PlayerRef)
	endif

	RegisterForSingleUpdate(2.0)
EndFunction


Function Setup()
	;Debug.Trace( "Setup: state=" + GetState() )

	if _KeyToTankLB != -1
		RegisterForKey(_KeyToTankLB)
	endif

	if _KeyToHealerLB != -1
		RegisterForKey(_KeyToHealerLB)
	endif

	if _KeyToMeleeLB != -1
		RegisterForKey(_KeyToMeleeLB)
	endif

	if _KeyToCasterLB != -1
		RegisterForKey(_KeyToCasterLB)
	endif

	if _KeyToOpenMenu != -1
		RegisterForKey(_KeyToOpenMenu)
	endif

	RegisterForMenu("Overlay Menu")
	RegisterForMenu("HUD Menu")
	RegisterForMenu("Overlay Interaction Menu")
	RegisterForMenu("InventoryMenu")
	RegisterForMenu("Console")
	RegisterForMenu("Dialogue Menu")
	RegisterForMenu("MessageBoxMenu")
	RegisterForMenu("MagicMenu")
	RegisterForMenu("Loading Menu")
	RegisterForMenu("TweenMenu")
	RegisterForMenu("BarterMenu")
	RegisterForMenu("GiftMenu")
	RegisterForMenu("MapMenu")
	RegisterForMenu("Lockpicking Menu")
	RegisterForMenu("Quantity Menu")
	RegisterForMenu("StatsMenu")
	RegisterForMenu("ContainerMenu")
	RegisterForMenu("Sleep/Wait Menu")
	RegisterForMenu("Journal Menu")
	RegisterForMenu("Book Menu")
	RegisterForMenu("FavoritesMenu")
	RegisterForMenu("RaceSex Menu")
	RegisterForMenu("Crafting Menu")
	RegisterForMenu("Training Menu")

	RegisterForModEvent("lbAddLevel", "OnAddLevel")
	RegisterForModEvent("hpPlayerRebirth", "OnPlayerRebirth")	; HomePoint
	RegisterForModEvent("hpPlayerDeath",   "OnPlayerDeath")		; HomePoint

	if !PlayerRef.HasPerk(aaaPerkLB)
		PlayerRef.AddPerk(aaaPerkLB)
	endif

	if GetState() != "DEAD"
		GoToState("ALIVE")
		RefreshMeter()
	endif
EndFunction


Function Cleanup()
	UnregisterForAllKeys()
	UnregisterForAllMenus()

	UnregisterForModEvent("hpPlayerRebirth")
	UnregisterForModEvent("hpPlayerDeath")
EndFunction


; インストール直後の最初のゲーム起動時
Event OnInit()
	RegisterForSingleUpdate(5.0)
EndEvent


Event OnMenuOpen(String asMenuName)
	if GetState() == "ALIVE"
		GoToState("IN_MENU")
	endif
EndEvent


Event OnAddLevel(string eventName, string strArg, float numArg, Form sender)
EndEvent


Event OnPlayerDeath(string eventName, string strArg, float numArg, Form sender)
	GoToState("DEAD")
EndEvent


Event OnPlayerRebirth(string eventName, string strArg, float numArg, Form sender)
	LimitBreakLevel = 0
	ActivatedLevel = 0
	GoToState("ALIVE")
EndEvent


Auto State INIT
	Event OnUpdate()
		aaaQuestMCM.AutoLoad()
		Setup()
	EndEvent
EndState


State ALIVE
	;Event OnBeginState()
		;Debug.Trace("ALIVE")
		;RefreshMeter()
	;EndEvent


	Event OnAddLevel(string eventName, string strArg, float numArg, Form sender)
		AddLimitBreakLevel(numArg as Int)
		;Debug.Trace("OnAddLevel: " + (numArg as Int) + " sender=" + sender)
	EndEvent


	Event OnKeyDown(Int aiKeyCode)
		;Debug.Trace("OnKeyDown: KeyCode=" + aiKeyCode)
		if ActivatedLevel
			return
		endif

		if aiKeyCode == _KeyToOpenMenu
			if CanUseLB(abHealerLB = true, abAutoActivate = false)
				Int iResult = aaaMessageSelectLB.Show()
				;Debug.Trace("OnKeyDown: Result=" + iResult)

				if iResult == 0
					if CanUseLB(abHealerLB = false)
						DoTankLB()
					endif
				elseif iResult == 1
					if CanUseLB(abHealerLB = true)
						DoHealerLB()
					endif
				elseif iResult == 2
					if CanUseLB(abHealerLB = false)
						DoMeleeLB()
					endif
				elseif iResult == 3
					if CanUseLB(abHealerLB = false)
						DoCasterLB()
					endif
				endif
			endif
		elseif aiKeyCode == _KeyToTankLB
			if CanUseLB(abHealerLB = false)
				DoTankLB()
			endif
		elseif aiKeyCode == _KeyToHealerLB
			if CanUseLB(abHealerLB = true)
				DoHealerLB()
			endif
		elseif aiKeyCode == _KeyToMeleeLB
			if CanUseLB(abHealerLB = false)
				DoMeleeLB()
			endif
		elseif aiKeyCode == _KeyToCasterLB
			if CanUseLB(abHealerLB = false)
				DoCasterLB()
			endif
		endif
	EndEvent


	Event OnUpdate()
		ResetLimitBreakLevel()
		Utility.Wait(1.0)
		RefreshMeter()
	EndEvent
EndState


State IN_MENU
	;Event OnBeginState()
	;	Debug.Trace("IN_MENU")
	;EndEvent


	Event OnMenuClose(String asMenuName)
		if !Utility.IsInMenuMode()
			GoToState("ALIVE")
		endif
	EndEvent
EndState